#include "monster.h"

Monster::Monster(Object *parent, float *mouse_x, float *mouse_y, double speed, bool *move_right, bool *move_left, bool *move_up, bool *move_down, bool *punch, bool *grab) : Material(parent)
{
	this->move_right = move_right;
	this->move_left = move_left;
	this->move_up = move_up;
	this->move_down = move_down;
	this->speed = speed;
	this->mouse_x = mouse_x;
	this->mouse_y = mouse_y;

	forward = new AtomDir();
	body = new Walker(this, forward);
	arm_dir = new MouseDir(NULL, mouse_x, mouse_y);
	arm = new Arm(this, arm_dir, grab, punch);
	feet_on_ground = 0;
	atoms_on_ground = 0;
	cooldown = 0;
	jumped = false;
	direction = 1;
	health = 1.0f;
	alive = true;

	body->assignAtomGroup(1);
	arm->assignAtomGroup(3);
	body->assignAtomGroup(4);
	arm->assignAtomGroup(6);
	arm->assignLinkGroup(1);
	arm->assignLinkGroup(2);
	arm->assignLinkGroup(3);

	setDrawOrder(10);
}

void Monster::die() {
	alive = false;
	health = 0.0f;

	Atom *a;
	center.begin();
	if(fabs(forward->dy) < 0.5f) {
		if(forward->dy < 0) {
			while(a = center.get()) {
				a->mass = 50.0f;
				a->rm = 1.0f / 50.0f;
				a->fx += 150.0f * direction;
			}
		}
		else {
			while(a = center.get()) {
				a->mass = 50.0f;
				a->rm = 1.0f / 50.0f;
				a->fx -= 150.0f * direction;
			}
		}
	}
	else {
		while(a = center.get()) {
			a->mass = 50.0f;
			a->rm = 1.0f / 50.0f;
		}
	}

	arm->drop();
	
	arm->top->stretch(1.0f);
	arm->bottom->stretch(1.0f);
	arm->middle->stretch(1.0f);

	removeObject(arm);
}

bool Monster::allowRepulse(Atom *a, Atom *b) {
	return Material::allowRepulse(a, b) && (a->y > 1 && b->y > 1);
}

void Monster::onRepulse(Atom *a, Atom *b, float force) {
	//if(b->in(this)) return;
	if(b->level != 7 || !alive || a->level == 2 || b->object == this || b->object->parent == this) return;
	if(force > 1.1f) {
		health -= (force - 1.1f) * 0.01f;
		if(health < 0.0f) die();
	}
}
	
void Monster::stepFunc()
{
	Material::stepFunc();
	if(!alive) return;

	cooldown--;

	Atom *c = forward->back;
	if(arm->held->atoms.length() == 0 && ((direction == 1 && *mouse_x < c->x) || (direction == -1 && *mouse_x > c->x))) {
		Atom *a;
		float ox;
		atoms.begin();
		while(a = atoms.get()) {
			ox = a->x;
			a->x = c->x + c->x - a->x;
			a->ox = a->ox - ox + a->x;
			//a->y = c->x + c->x - a->y;
			//a->oy = c->x + c->x - a->oy;
		}
		direction = -direction;
	}

	float impediment;
	if(arm->charging && arm->power > 1.0f)
		impediment = 0.3f;
	else
		impediment = 1.0f;

	if(*move_right) {
		if(feet_on_ground == 3)
			body->applyForce(speed * direction * impediment);
		else {
			if(arm->held->atoms.length() != 0)
				body->applyForce(speed * 0.6f * direction * impediment);
			else
				body->applyForce(speed * 0.2f * direction * impediment);
		}
	}

	if(*move_left) {
		if(feet_on_ground == 3)
			body->applyForce(-speed * direction * impediment);
		else {
			if(arm->held->atoms.length() != 0)
				body->applyForce(-speed * 0.6f * direction * impediment);
			else
				body->applyForce(-speed * 0.2f * direction * impediment);
		}
	}
	if(!*move_up) jumped = false;
	if(*move_up && !jumped) {

		const float side = 2.0f * impediment;
		const float up = 10.0f * impediment;

		if(feet_on_ground > 1) {
			applyForce(4 * side * direction, 3 * up);
			jumped = true;
		}
		else if(atoms_on_ground > 0 && cooldown < 0) {
			float force = 50.0f + arm->held->atoms.length();
			Atom *a;
			center.begin();
			while(a = center.get()) {
				a->fy += force;
			}
			cooldown = 50;
			jumped = true;
		}
		else if(atoms_on_ground == 0 && arm->held->atoms.length() > 0) {
			arm->drop();
			//applyForce(0 * side, 1.5 * up);
			Atom *a;
			atoms.begin();
			if(*move_left && !*move_right) {
				while(a = atoms.get()) {
					a->fy += a->mass * 3.0f * impediment;
					a->fx -= a->mass * 0.5f * direction  * impediment;
				}
			}
			else if(*move_right && !*move_left) {
				while(a = atoms.get()) {
					a->fy += a->mass * 3.0f * impediment;
					a->fx += a->mass * 0.5f * direction * impediment;
				}
			}
			else {
				while(a = atoms.get()) {
					a->fy += a->mass * 3.0f * impediment;
					//a->fx += a->mass * 0.5f;
				}
			}
			jumped = true;
		}
	}
	if(*move_down) {
		arm->drop();
	}
	/*
	if(*move_right && feet_on_ground > 4) {
		applyForce(side, up);
	}
	if(*move_left && feet_on_ground > 4) {
		applyForce(-side, up);
	}
	*/

	feet_on_ground = 0;
	atoms_on_ground = 0;
}

void Monster::atomFunc(Atom *a) {
	if(a->y < 1) {
		if(a->group == 4) feet_on_ground++;
		else atoms_on_ground++;
	}
	
	Material::atomFunc(a);
}

void Monster::addAtom(Atom *a) {
    Material::addAtom(a);

    if(a->group == 1) {
		forward->back = a;
    }
    else if(a->group == 2) {
		forward->front = a;
		arm_dir->atom = a;
    }
	else if(a->group == 5) {
		arm_dir->atom = a;
	}
	else if(a->group == 7) {
		center.add(a);
	}
	else if(a->group == 8) {
		center.add(a);
	}
}

void Monster::addPoly(Poly *p) {
	Material::addPoly(p);
	p->draw = false;
}

void Monster::draw() {
	Material::draw();
	if(polys.length() == 0) return;

	glTranslatef(0.0f, 0.0f, 1.0f);
	Poly *p;
	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glEnable(GL_TEXTURE_2D);
	polys.begin();
	p = polys.get();
	glBindTexture(GL_TEXTURE_2D, p->texture->texID);	
	glBegin(GL_TRIANGLES);
	while(p) {
		glTexCoord2f(p->rtx1, p->rty1);	glVertex3f(*(p->x1), *(p->y1), 0.1f);
		glTexCoord2f(p->rtx2, p->rty2);	glVertex3f(*(p->x2), *(p->y2), 0.1f);
		glTexCoord2f(p->rtx3, p->rty3);	glVertex3f(*(p->x3), *(p->y3), 0.1f);
		p = polys.get();
	}
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glTranslatef(0.0f, 0.0f, -1.0f);
}